/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorClientBehaviour;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorPackagePhysicsData;
import com.zurrtum.create.client.foundation.render.CreateRenderTypes;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.logistics.box.PackageItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class ChainConveyorRenderer
extends KineticBlockEntityRenderer<ChainConveyorBlockEntity, ChainConveyorRenderState> {
    public static final class_2960 CHAIN_LOCATION = class_2960.method_60656((String)"textures/block/iron_chain.png");
    public static final int MIP_DISTANCE = 48;

    public ChainConveyorRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public ChainConveyorRenderState createRenderState() {
        return new ChainConveyorRenderState();
    }

    @Override
    public void extractRenderState(ChainConveyorBlockEntity be, ChainConveyorRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        class_1937 world = be.method_10997();
        if (state.support) {
            class_2338 pos = be.method_11016();
            state.chains = this.getChainsRenderState(be, world, pos, cameraPos);
            if (state.chains == null) {
                return;
            }
            state.field_62673 = pos;
            state.field_62675 = be.method_11017();
            state.chain = CreateRenderTypes.chain(CHAIN_LOCATION);
            return;
        }
        state.chains = this.getChainsRenderState(be, world, state.field_62673, cameraPos);
        state.wheel = CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_WHEEL, state.field_62674);
        if (state.chains != null) {
            state.chain = CreateRenderTypes.chain(CHAIN_LOCATION);
            state.guard = CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_GUARD, state.field_62674);
        }
        ArrayList<BoxRenderState> boxes = new ArrayList<BoxRenderState>();
        for (ChainConveyorPackage chainConveyorPackage : be.getLoopingPackages()) {
            ChainConveyorPackagePhysicsData data = this.getPhysicsData(world, chainConveyorPackage);
            if (data == null) continue;
            boxes.add(this.getBoxRenderState(world, state.field_62674, state.field_62673, chainConveyorPackage, data, tickProgress));
        }
        for (Map.Entry entry : be.getTravellingPackages().entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                ChainConveyorPackagePhysicsData data = this.getPhysicsData(world, box);
                if (data == null) continue;
                boxes.add(this.getBoxRenderState(world, state.field_62674, state.field_62673, box, data, tickProgress));
            }
        }
        if (boxes.isEmpty()) {
            return;
        }
        state.boxes = boxes;
    }

    @Override
    public void submit(ChainConveyorRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.chains != null) {
            for (ChainRenderState chain : state.chains) {
                chain.render(matrices, state.chain, queue);
            }
        }
    }

    public ChainConveyorPackagePhysicsData getPhysicsData(class_1937 world, ChainConveyorPackage box) {
        if (box.worldPosition == null || box.item == null || box.item.method_7960()) {
            return null;
        }
        ChainConveyorPackagePhysicsData physicsData = ChainConveyorClientBehaviour.physicsData(box, (class_1936)world);
        if (physicsData.prevPos == null) {
            return null;
        }
        if (physicsData.modelKey == null) {
            class_2960 key = class_7923.field_41178.method_10221((Object)box.item.method_7909());
            if (key == class_7923.field_41178.method_10137()) {
                return null;
            }
            physicsData.modelKey = key;
        }
        return physicsData;
    }

    public BoxRenderState getBoxRenderState(class_1937 world, class_2680 blockState, class_2338 pos, ChainConveyorPackage box, ChainConveyorPackagePhysicsData physicsData, float partialTicks) {
        BoxRenderState state = new BoxRenderState();
        class_243 position = physicsData.prevPos.method_35590(physicsData.pos, (double)partialTicks);
        class_243 targetPosition = physicsData.prevTargetPos.method_35590(physicsData.targetPos, (double)partialTicks);
        float yaw = AngleHelper.angleLerp(partialTicks, physicsData.prevYaw, physicsData.yaw);
        state.yaw = (float)Math.PI / 180 * yaw;
        state.offset = new class_243(targetPosition.field_1352 - (double)pos.method_10263(), targetPosition.field_1351 - (double)pos.method_10264(), targetPosition.field_1350 - (double)pos.method_10260());
        class_2338 containingPos = class_2338.method_49638((class_2374)position);
        state.light = class_765.method_23687((int)world.method_8314(class_1944.field_9282, containingPos), (int)world.method_8314(class_1944.field_9284, containingPos));
        class_243 dangleDiff = VecHelper.rotate(targetPosition.method_1031(0.0, 0.5, 0.0).method_1020(position), -yaw, class_2350.class_2351.field_11052);
        float zRot = class_3532.method_15393((float)((float)class_3532.method_15349((double)(-dangleDiff.field_1352), (double)dangleDiff.field_1351) * 57.295776f)) / 2.0f;
        float xRot = class_3532.method_15393((float)((float)class_3532.method_15349((double)dangleDiff.field_1350, (double)dangleDiff.field_1351) * 57.295776f)) / 2.0f;
        state.zRot = (float)Math.PI / 180 * class_3532.method_15363((float)zRot, (float)-25.0f, (float)25.0f);
        state.xRot = (float)Math.PI / 180 * class_3532.method_15363((float)xRot, (float)-25.0f, (float)25.0f);
        if (physicsData.flipped) {
            state.yRot = (float)Math.PI;
        }
        state.offsetY = -PackageItem.getHookDistance(box.item) + 0.4375f;
        state.rig = CachedBuffers.partial(AllPartialModels.PACKAGE_RIGGING.get(physicsData.modelKey), blockState);
        state.box = CachedBuffers.partial(AllPartialModels.PACKAGES.get(physicsData.modelKey), blockState);
        return state;
    }

    @Nullable
    public List<ChainRenderState> getChainsRenderState(ChainConveyorBlockEntity be, class_1937 world, class_2338 tilePos, class_243 cameraPos) {
        ArrayList<ChainRenderState> chains = new ArrayList<ChainRenderState>();
        class_243 position = class_243.method_24953((class_2382)tilePos);
        boolean renderWorld = class_310.method_1551().field_1687 == world;
        float time = AnimationTickHolder.getRenderTime((class_1936)world) / (360.0f / Math.abs(be.getSpeed()));
        if ((time %= 1.0f) < 0.0f) {
            time += 1.0f;
        }
        float animation = time - 0.5f;
        int light1 = class_765.method_23687((int)world.method_8314(class_1944.field_9282, tilePos), (int)world.method_8314(class_1944.field_9284, tilePos));
        float yRot = 0.7853982f;
        for (class_2338 blockPos : be.connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = be.connectionStats.get(blockPos);
            if (stats == null) continue;
            boolean far = renderWorld && !cameraPos.method_24802((class_2374)class_243.method_24953((class_2382)tilePos).method_1031((double)((float)blockPos.method_10263() / 2.0f), (double)((float)blockPos.method_10264() / 2.0f), (double)((float)blockPos.method_10260() / 2.0f)), 48.0);
            ChainRenderState state = far ? new FarChainRenderState() : new ChainRenderState();
            class_243 diff = stats.end().method_1020(stats.start());
            state.startOffset = stats.start().method_1020(position);
            state.yaw = (float)class_3532.method_15349((double)diff.field_1352, (double)diff.field_1350);
            state.pitch = (float)(0.01745329238474369 * (90.0 - 57.2957763671875 * class_3532.method_15349((double)diff.field_1351, (double)diff.method_18805(1.0, 0.0, 1.0).method_1033())));
            state.yRot = yRot;
            class_2338 pos = tilePos.method_10081((class_2382)blockPos);
            state.light1 = light1;
            state.light2 = class_765.method_23687((int)world.method_8314(class_1944.field_9282, pos), (int)world.method_8314(class_1944.field_9284, pos));
            state.animation = animation;
            state.length = stats.chainLength();
            state.maxV = far ? 0.0625f : state.length + animation;
            chains.add(state);
        }
        if (chains.isEmpty()) {
            return null;
        }
        return chains;
    }

    private static void renderPart(class_4587.class_4665 pose, class_4588 pConsumer, float pMaxY, float pX0, float pZ0, float pX1, float pZ1, float pX2, float pZ2, float pX3, float pZ3, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2, float uO) {
        Matrix4f matrix4f = pose.method_23761();
        ChainConveyorRenderer.renderQuad(matrix4f, pose, pConsumer, 0.0f, pMaxY, pX0, pZ0, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, pose, pConsumer, 0.0f, pMaxY, pX3, pZ3, pX0, pZ0, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, pose, pConsumer, 0.0f, pMaxY, pX1, pZ1, pX2, pZ2, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, pose, pConsumer, 0.0f, pMaxY, pX2, pZ2, pX1, pZ1, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
    }

    private static void renderQuad(Matrix4f pPose, class_4587.class_4665 pNormal, class_4588 pConsumer, float pMinY, float pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2) {
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMinX, pMinZ, pMaxU, pMinV, light2);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMinX, pMinZ, pMaxU, pMaxV, light1);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMaxX, pMaxZ, pMinU, pMaxV, light1);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMaxX, pMaxZ, pMinU, pMinV, light2);
    }

    private static void addVertex(Matrix4f pPose, class_4587.class_4665 pNormal, class_4588 pConsumer, float pY, float pX, float pZ, float pU, float pV, int light) {
        pConsumer.method_22918((Matrix4fc)pPose, pX, pY, pZ).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(pU, pV).method_22922(class_4608.field_21444).method_60803(light).method_60831(pNormal, 0.0f, 1.0f, 0.0f);
    }

    public int method_33893() {
        return 256;
    }

    public boolean method_3563() {
        return true;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(ChainConveyorBlockEntity be, ChainConveyorRenderState state) {
        return CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_SHAFT, state.field_62674);
    }

    @Override
    protected class_1921 getRenderType(ChainConveyorBlockEntity be, class_2680 state) {
        return class_12249.method_75972();
    }

    @Environment(value=EnvType.CLIENT)
    public static class ChainConveyorRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public SuperByteBuffer wheel;
        public SuperByteBuffer guard;
        public class_1921 chain;
        public List<ChainRenderState> chains;
        public List<BoxRenderState> boxes;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            this.wheel.light(this.field_62676).overlay(class_4608.field_21444).renderInto(matricesEntry, vertexConsumer);
            if (this.guard != null) {
                for (ChainRenderState chain : this.chains) {
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.guard.center()).rotateY(chain.yaw)).uncenter()).light(this.field_62676).overlay(class_4608.field_21444).renderInto(matricesEntry, vertexConsumer);
                }
            }
            if (this.boxes != null) {
                for (BoxRenderState box : this.boxes) {
                    box.render(matricesEntry, vertexConsumer);
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class BoxRenderState {
        public SuperByteBuffer rig;
        public SuperByteBuffer box;
        public float yaw;
        public class_243 offset;
        public float zRot;
        public float xRot;
        public float yRot;
        public float offsetY;
        public int light;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.rig.translate(this.offset)).translate(0.0f, 0.625f, 0.0f)).rotateY(this.yaw)).rotateZ(this.zRot)).rotateX(this.xRot)).rotateY(this.yRot)).uncenter();
            ((SuperByteBuffer)this.rig.translate(0.0f, this.offsetY, 0.0f)).light(this.light).overlay(class_4608.field_21444).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.box.translate(this.offset)).translate(0.0f, 0.625f, 0.0f)).rotateY(this.yaw)).rotateZ(this.zRot)).rotateX(this.xRot)).uncenter();
            ((SuperByteBuffer)this.box.translate(0.0f, this.offsetY, 0.0f)).light(this.light).overlay(class_4608.field_21444).renderInto(matricesEntry, vertexConsumer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ChainRenderState
    implements class_11659.class_11660 {
        public class_243 startOffset;
        public float yaw;
        public float pitch;
        public float yRot;
        public float animation;
        public float length;
        public int light1;
        public int light2;
        public float maxV;

        public void render(class_4587 matrices, class_1921 layer, class_11659 queue) {
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_61958(this.startOffset);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.yaw));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(this.pitch));
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.yRot));
            queue.method_73483(matrices, layer, (class_11659.class_11660)this);
            matrices.method_22909();
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ChainConveyorRenderer.renderPart(matricesEntry, vertexConsumer, this.length, 0.0f, 0.09375f, 0.09375f, 0.0f, -0.09375f, 0.0f, 0.0f, -0.09375f, 0.0f, 0.1875f, this.animation, this.maxV, this.light1, this.light2, 0.1875f);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FarChainRenderState
    extends ChainRenderState {
        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            ChainConveyorRenderer.renderPart(matricesEntry, vertexConsumer, this.length, 0.0f, 0.0625f, 0.0625f, 0.0f, -0.0625f, 0.0f, 0.0f, -0.0625f, 0.1875f, 0.25f, 0.0f, this.maxV, this.light1, this.light2, 0.0f);
        }
    }
}

